#
# $Id$
#
%define perlvendorlib %(eval "`%{__perl} -V:installvendorlib`"; echo $installvendorlib)
%define srcname rpmbootstrap

Summary:	Tool similar to debootstrap for RPM based distributions
Summary(fr):	Outil similaire à debootstrap pour une distribution RPM.

Name:		rpmbootstrap
Version:	0.16.2
Release:	1.fc35
License:	GPLv2
Group:		Applications/Archiving
Url:		http://trac.project-builder.org
Source:		ftp://ftp.project-builder.org//src/%{srcname}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(id -u -n)
BuildArch:	noarch
Requires:	perl >= 5.8.4,perl-ProjectBuilder,perl-libwww-perl,wget,


%description
It helps building a chrooted environment for RPM based distributions
in a similar way as debootstrap for deb based distributions.

%description -l fr
La commande rpmbootstrap crée un environnement chrooté pour la distribution
RPM concernée.
Il est similaire à debootstrap pour les distributions .deb

%prep
%setup -q -n %{srcname}-%{version}

%build
%{__perl} Makefile.PL INSTALLDIRS=vendor destdir=${RPM_BUILD_ROOT}/
make

%install
%{__rm} -rf $RPM_BUILD_ROOT
make DESTDIR=${RPM_BUILD_ROOT} install
find ${RPM_BUILD_ROOT} -type f -name perllocal.pod -o -name .packlist -o -name '*.bs' -a -size 0 | xargs rm -f
find ${RPM_BUILD_ROOT} -type d -depth | xargs rmdir --ignore-fail-on-non-empty

%check
make test

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc NEWS AUTHORS
%doc INSTALL COPYING README

#%{perlvendorlib}/*
%{_bindir}/*
%{_mandir}/man1/*
#%{_mandir}/man3/*

%changelog
* Tue Aug 09 2022 Bruno Cornec <bruno@project-builder.org> 0.16.2-1
- Updated to 0.16.2
- Add build support for Fedora 34/35/36, OpenSUSE 15.3/15.4, Ubuntu 21.10/22.04, Debian 12, Rocky/Alma 9 and Mageia 8 (Bruno Cornec)

* Wed Aug 19 2020 Bruno Cornec <bruno@project-builder.org> 0.16.1-1
- Updated to 0.16.1
- No change

* Sun Feb 23 2020 Bruno Cornec <bruno@project-builder.org> 0.15.3-1
- Updated to 0.15.3
- No major Change

* Sat Sep 07 2019 Bruno Cornec <bruno@project-builder.org> 0.15.2-1
- Updated to 0.15.2
- Force explicit analysis of boolean when using cluck (Bruno Cornec) 
- Update default list of distributions supported (Bruno Cornec)

* Mon Mar 18 2019 Bruno Cornec <bruno@project-builder.org> 0.15.1-1
- Updated to 0.15.1
- Fix list of supported distributions for pb with the YAML changes (Bruno Cornec)

* Wed Sep 06 2017 Bruno Cornec <bruno@project-builder.org> 0.14.6-1
- Updated to 0.14.6
- Add Debian 9 container generation capability (Bruno Cornec)
- Adds https_proxy support (Bruno Cornec)

* Sat Jun 24 2017 Bruno Cornec <bruno@project-builder.org> 0.14.5-1
- Updated to 0.14.5
- No change

* Sat Mar 11 2017 Bruno Cornec <bruno@project-builder.org> 0.14.4-1
- Updated to 0.14.4
- No change

* Sat Mar 04 2017 Bruno Cornec <bruno@project-builder.org> 0.14.3-1
- Updated to 0.14.3
- No change

* Wed Jan 04 2017 Bruno Cornec <bruno@project-builder.org> 0.14.2-1
- Updated to 0.14.2
- No change

* Mon Jul 25 2016 Bruno Cornec <bruno@project-builder.org> 0.14.1-1
- Updated to 0.14.1
- No change

* Wed Feb 17 2016 Bruno Cornec <bruno@project-builder.org> 0.13.2-1
- Updated to 0.13.2
- No change

* Wed Nov 25 2015 Bruno Cornec <bruno@project-builder.org> 0.13.1-1
- Updated to 0.13.1
- Adds preliminary dnf support for new Fedora 22+ versions (Bruno Cornec)
- Fix an issue with cpio not extracting files if in a dir being a link (Bruno Cornec)
- Cleanup in list of chroot supported (Bruno Cornec)
- Fix a bug in rpmbootstrap in case of abbreviated desc on web page. We now use $pkg instead of truncated $desc (Michel Promonet)

* Thu Feb 05 2015 Bruno Cornec <bruno@project-builder.org> 0.12.7-1
- Updated to 0.12.7
- No change

* Sun Jun 22 2014 Bruno Cornec <bruno@project-builder.org> 0.12.6-1
- Updated to 0.12.6
- No change

* Tue Feb 04 2014 Bruno Cornec <bruno@project-builder.org> 0.12.5-1
- Updated to 0.12.5
- No change

* Wed Jan 15 2014 Bruno Cornec <bruno@project-builder.org> 0.12.4-1
- Updated to 0.12.4
- No change

* Sun Jan 05 2014 Bruno Cornec <bruno@project-builder.org> 0.12.3-1
- Updated to 0.12.3
- Adds support for Fedora 18, 19 and 20 and Mageia 3 (Bruno Cornec)
- filesystem is now extracted first for systemd symlinks crazyness support (Bruno Cornec)
- rbs_mirror_response now also returns the repo found which could be different from the initial mirror in case of metadata dir for yum (Bruno Cornec)

* Tue Feb 26 2013 Bruno Cornec <bruno@project-builder.org> 0.12.2-1
- Updated to 0.12.2
- Adds Red Hat 6.2 (not RHEL !) support (Bruno Cornec)
- Tested with opensuse 12.2 (Bruno Cornec)
- rpmbootstrap now supports non-yum type of install with a full list of deps. (Bruno Cornec)

* Mon May 28 2012 Bruno Cornec <bruno@project-builder.org> 0.12.1-1
- Updated to 0.12.1
- rpmbootstrap needs aaa_base for VE seyup with zypper, in order to add passwd file e.g. (Bruno Cornec)
- If we have a proxy defined, write it into /etc/sysconfig/proxy. Otherwise one of the opensuse's doesn't work right. (Eric Anderson)
- Improve error message, include why the download failed (Eric Anderson)
- Download files to a temporary name so that ctrl-c won't leave around bad .rpm files. (Eric Anderson)
- Add support for stop-on-error. (Eric Anderson)
- Error out if no packages are defined for the OS version since that indicates something is badly wrong. (Eric Anderson)
- Track the packages that we install so that we can re-install them with the vendor's tool.  (Eric Anderson)
- Don't mount proc if it is already mounted.  (Eric Anderson)
- Only process repo files under yum.repos.d. (Eric Anderson)
- Report on broken packages listed for installation at the end so the warning isn't hidden. (Eric Anderson)
- Fix rpmbootstrap to support sites with multiple href in their page (opensuse main site e.g) (Bruno Cornec)
- Fix conf to support VE for opensuse 12.1 (Bruno Cornec)
- Improved description, documentation and web pages (Eric Anderson)
- Exit when no mirror defined to build a VE (Bruno Cornec)
- Fix #105: create /dev/null in the chroot to avoid getting a file with errors in it. (Bruno Cornec)

* Wed May 25 2011 Bruno Cornec <bruno@project-builder.org> 0.11.3-1
- Updated to 0.11.3
- Working VE for opensuse-11.4 (Bruno Cornec)
- some corresponding fixes for rpmbootstrap that would also need backward checks now (Bruno Cornec)

* Sat Mar 12 2011 Bruno Cornec <bruno@project-builder.org> 0.11.2-1
- Updated to 0.11.2
- Try to be more error proof when issues with repository download (Bruno Cornec)
- Fix rpmbootstrap and pb newve order, which wasn't working after the latest pbos introduction (Bruno Cornec)
- rpmbootstrap wasn't using the right conf file when launched with sudo is fixed by using the SUDO_USER env. var. (Bruno Cornec)
- pb.conf rbsmirrorsrv now uses pbos var, and is filtered correctly. (Bruno Cornec)

* Sat Feb 26 2011 Bruno Cornec <bruno@project-builder.org> 0.11.1-1
- Updated to 0.11.1
- rpmbootstrap wasn't using the right conf file when launched with sudo is fixed by using the SUDO_USER env. var. (Bruno Cornec)
- pb.conf rbsmirrorsrv now uses pbos var, and is filtered correctly. (Bruno Cornec)
- Introduction of a new hash $pbos to manage all os related info through a single data structure. All functions reviewed accordingly. Externally transparent, hopefully, but much cleaner code as a consequence. (Bruno Cornec)

* Thu Jan 13 2011 Bruno Cornec <bruno@project-builder.org> 0.10.1-1
- Updated to 0.10.1
- Adds fedora 14 support for rpmbootstrap (Bruno Cornec)
- Improve Fedora 13 VE support (Bruno Cornec)
- rpmboostrap now uses pb_check_req (Bruno Cornec)
- Remove most lintian warnings for Debian (Bruno Cornec)
- Fix Mandriva 2010.1 VE built with right dep pkg list (Bruno Cornec)
- various rpmlint and lintian fixes (Bruno Cornec)
- Adds ebuild version for pb gentoo packages (Bruno Cornec)

* Mon Jun 07 2010 Bruno Cornec <bruno@project-builder.org> 0.9.10-1
- Updated to 0.9.10
- Add support for Ubuntu 10.04 natively and with debootstrap (universe repo needed) (Bruno Cornec)
- Project-Builder.org is licensed under the GPL v2 for the moment. (Bruno Cornec)
- Adds rbsopt parameter + doc to allow for passing options to rpmbootstrap such as -k now by default. (Bruno Cornec)
- Successful tests with some VE (Mandriva 2009.1 and 2010.0, CentOS 4 & 5, Fedora 12, Ubuntu 10.04, Debian 5) (Bruno Cornec)
- The repodata dir is now search in the parents dir of the mirror given as it depends on yum version. (Bruno Cornec)

* Sat May 01 2010 Bruno Cornec <bruno@project-builder.org> 0.9.9-1
- Updated to 0.9.9
- First version of the rpmbootstrap program based on debootstrap and rinse ideas (Bruno Cornec)


