#
# $Id$
#
%define perlvendorlib %(eval "`%{__perl} -V:installvendorlib`"; echo $installvendorlib)
%define srcname MondoRescue

Summary:	The PBREALPKG provides a set of functions for the MondoRescue project
Summary(fr):	Une bibliothèque de fonction de bas niveau pour le projet MondoRescue

Name:		perl-MondoRescue
Version:	3.2.3
Release:	1.mga4
License:	GPLv2+
Group:		Archiving/Backup
Url:		http://www.mondorescue.org
Source:		ftp://ftp.mondorescue.org//src/%{srcname}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{srcname}-%{version}-%{release}-root-%(id -u -n)
BuildArch:	noarch
Requires:	perl >= 5.6.2,perl-ProjectBuilder,
BuildRequires:	perl

%description
The perl-MondoRescue provides a set of functions for the MondoRescue project

%description -lfr
Une bibliothèque de fonction de bas niveau pour le projet MondoRescue

%prep
%setup -q -n %{srcname}-%{version}

%build
%{__perl} Makefile.PL destdir=${RPM_BUILD_ROOT}/ CONFDIR=%{_sysconfdir} CACHEDIR=%{_var}/cache TARGET=%{_exec_prefix}
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install
find ${RPM_BUILD_ROOT} -type f -name perllocal.pod -o -name .packlist -o -name '*.bs' -a -size 0 | xargs rm -f
find ${RPM_BUILD_ROOT} -type d -depth | xargs rmdir --ignore-fail-on-non-empty

%check
make test

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%config(noreplace) %{_sysconfdir}/mondorescue
%doc ChangeLog INSTALL COPYING README NEWS AUTHORS

%{_bindir}/*
%{_mandir}/man1/*
%{perlvendorlib}/*
%{_mandir}/man3/*
%{_mandir}/man5/*
#%{_datadir}/mondorescue
#%{_var}/cache/mondorescue

%changelog
* Tue Apr 01 2025 Bruno Cornec <bruno@mondorescue.org> 3.2.3-1
- Updated to 3.2.3
- No change

* Thu Apr 28 2016 Bruno Cornec <bruno@mondorescue.org> 3.2.2-1
- Updated to 3.2.2
- Fix #785 by returning conf values when NFS server not on the same LAN as the client (Bruno Cornec)
- Fix #778 by adding a mr-label tool to manage fat FS labelling and identification with uuid (Bruno Cornec)
- Adds a mr-disk-type program and perl function to list all disks on the system (Bruno Cornec)

* Sat Aug 29 2015 Bruno Cornec <bruno@mondorescue.org> 3.2.1-1
- Updated to 3.2.1
- Adds a mr-device-mounted binary to MondoRescue (replace code of the C function is_this_device_mounted) and the corresponding perl function (mr_device_mounted) to handle cases where a mounted device has a different name than the one seen on mount (e.g. /dev/rhel/root and /dev/mapper/rhel-root) (Bruno Cornec)
- Adds perl function mr_file_copy_and_erase_hash to empty the hash generated in mr_file_read_all_link and thus avoid filling the hash it generates, which is useful for a recursive function, but not when called multiple times from another perl script. (Bruno Cornec)
- Fix podchecker warnings (Bruno Cornec)
- Adds a Disk.pm module to centralize all disk related functions for MondoRescue (Bruno Cornec)
- mr-kernel-get-modules now uses Getopt for parameter management, allowing verbosity increase (Bruno Cornec)
- Fix mr_kernel_get_modules to support depmod version providing relative paths such as on RHEL5 (Bruno Cornec)
- Fix mr_kernel_get_modules to support modinfo version without -k option support, using module full path instead (Bruno Cornec)
- The modlist hash is now having keys being full path module names as a consequence (Bruno Cornec)
- Adds a new Version.pm module to get version management a la pb in MondoRescue (Bruno Cornec)

* Tue Dec 23 2014 Bruno Cornec <bruno@mondorescue.org> 3.2.0-1
- Updated to 3.2.0
- First version provided under the GPL v2 of this new perl package hosting all perl functions needed by MondoRescue (Bruno Cornec)
- Fix an issue for older perl version where the code was incompatible (Dider Diaz)
- Adds a script mr-net-get-config to comput the network configuration and generate the appropriate portion of the configuration file (Bruno Cornec)
- Adds a script mr_file_read_all_link returning a hash of hash of all links found for a given file (Bruno Cornec)
- Adds a script mr-process-ldd returning all the dynamic libraries found for a given file (Bruno Cornec)
- Adds a script mr-kernel-get-modules returning the list of all the full paths for all modules passed in parameters with their dependencies (Bruno Cornec)
- The test function of MondoRescue is now also working for distros not having natively Test::More and avoid to depend on it (Bruno Cornec)


